/*
 * Andrea Di Biagio
 * Politecnico di Milano, 2007
 * 
 * axe_array.h
 * Formal Languages & Compilers Machine, 2007/2008
 * 
 */

#ifndef _AXE_ARRAY_H
#define _AXE_ARRAY_H

#include "axe_engine.h"
#include "axe_struct.h"

/* This function takes as input: a variable identifier (ID)
 * that refers to an array value; an index value that
 * refers to a specific element of the array. Once
 * called, this function returns a register location identifier
 * that will contain the value of the array element at position
 * `index'. Index is an expression: its value
 * can be either a register location (i.e. the value of
 * `index' is stored inside a register) or an immediate value. */
extern int loadArrayElement(t_program_infos *program
               , char *ID, t_axe_expression index);

/* This function takes as input: a variable identifier (ID)
 * that refers to an array value; an index value that
 * refers to a specific element of the array. Once
 * called, this function returns a register location identifier
 * that will contain the address of the array element at position
 * `index'. Index is an expression: its value
 * can be either a register location (i.e. the value of
 * `index' is stored inside a register) or an immediate value. */
extern int loadArrayAddress(t_program_infos *program
               , char *ID, t_axe_expression index);

/* This function takes as input: a variable identifier (ID)
 * that refers to an array value; an index value that
 * refers to a specific element of the array. Once
 * called, this function stores a value referred by `data' inside
 * the array at position `index'. `data' and `index' are expressions :
 * their value can be either register locations (i.e. their values
 * are stored inside a register) or immediate values. */
extern void storeArrayElement(t_program_infos *program, char *ID
            , t_axe_expression index, t_axe_expression data);

#endif
