/*
 * Giovanni Agosta, Andrea Di Biagio
 * Politecnico di Milano, 2007
 * 
 * machine.c
 * Formal Languages & Compilers Machine, 2007/2008
 * 
 */

#include "machine.h"

void print_regs(FILE *file)
{
	/* Debug printf, stampa i registri correnti */
	int i;
	for (i=0; i<NREGS; i++)
	fprintf(file,"R%d=%2d\t", i, reg[i]);
	fprintf(file,"\n\n\n");
}

void print_stack(FILE *file, int begin)
{
	/* Debug, stampa la pila del programma      */
	int i;
	fprintf(file,"Stack: ");
	for (i=begin; i<reg[SP]; i++)
	fprintf(file,"%d\t", mem[i]);
	fprintf(file,"\n");
}

/* Get flag from processor status word */
unsigned int getflag(int flag)
{
	return getbits(psw, flag, flag);
}

/* Set flag in processor status word*/
void setflag(int flag, int value){
	int mask = 1<<flag;
	if (value)
		psw = psw | mask;
	else 
		psw = psw & ~mask;
}
