/* Count number of characters in argv[1], 
   the first parameter of the program        */
.arm 		/* Use ARM 32-bit instruction set    */
.text 	/* Begin code section                */
.align 	/* Default alignment                 */
.global main	/* Declare global name "main"  */
.type main, %function	/* main is a function  */
main : 
	push { fp, lr }			/* save FP and LR      */
	ldr r1, [r1, #4]	  /* Load address of second parameter (a 32-bit value) */
	mov r4, #0					/* initialize R4 at 0  (R4 is the length counter     */
	mov r5, #1					/* initialize R5 at 1  (R5 will hold the value of each character) */
loop:
	cmp r5, #0					/* compare R0 and 0 -- all strings are 0-terminated  */
	beq end		 					/* jump to end if R0==0  */
	ldrb r5, [r1, r4]	  /* R5 = mem[R1+R4], load a single character! */
	add r4, r4, #1			/* R4=R4+1             */
	b loop							/* jump to loop start  */
end:
	sub r0, r4, #1	    /* copy R4-1 to R0 (return value) */
	pop { fp, lr }			/* restore FP and LR   */
	bx lr								/* return              */
.end                  /* denotes end of file */
