/* Example of While loop in ARM assembly     */
.arm 		/* Use ARM 32-bit instruction set    */
.text 	/* Begin code section                */
.align 	/* Default alignment                 */
.global main	/* Declare global name "main"  */
.type main, %function	/* main is a function  */
main : 
	push { fp, lr }			/* save FP and LR      */
	mov r4, #3					/* initialize R4 at 3  */
	mov r5, #3					/* initialize R5 at 3  */
loop:
	cmp r0, #0					/* compare R0 and 0    */
	beq end		 					/* jump to end if R0==0  */
	mul r4, r5, r4			/* R4 = R4 * 3         */
	sub r0, r0, #1			/* R0=R0-1             */
	b loop							/* jump to loop start  */
end:
	mov r0, r4					/* copy R4 to R0 (return value) */
	pop { fp, lr }			/* restore FP and LR   */
	bx lr								/* return              */
.end                  /* denotes end of file */
