#include <stdlib.h>
#include <string.h>
#include "dqsortl.h"

void swap(size_t size, void *x, void *y){
	void *tmp = malloc(size);
	memcpy(tmp,x,size);
	memcpy(x,y,size);
	memcpy(y,tmp,size);
	free(tmp);
}

void quicksort(void *array, size_t size, 
               int left, int right, 
               void *(*cmp)(void *, void *)){
	void *pivot = array+(left*size);
	int last=left;
	void *l;
	int i;
	if (left>=right) return;
	for(l=array+((left+1)*size); 
	    l<=(void *)(array+(right*size)); 
			l+=size) {
		if (((int)(*cmp)(l, array+(left*size)))<0) {
			swap(size,l,pivot+size);
			pivot+=size;
			last++;
		}
	}
	swap(size,array+(left*size),pivot);
	quicksort(array,size,left,last-1,cmp);
	quicksort(array,size,last+1,right,cmp);
}
