#include <stdio.h>

#define N 4
#define OK 0
#define NOTFOUND 1
#define FULL 2

/*
 * Array "display_table" provides an association 
 * among objects and display functions.
 */
struct {
  void *obj;
	void (*fun)(void *obj);
} display_table[N] = {
	{NULL,NULL},
	{NULL,NULL},
	{NULL,NULL},
	{NULL,NULL}
};

/*
 * The display function takes a generic "object"
 * and applies the appropriate display function
 */
int display(void *object){
	int i;
  for(i=0; display_table[i].obj!=NULL && i<N; i++) {
	 	if (display_table[i].obj==object) {
			display_table[i].fun(object);
			return OK;
		}
	}
	return NOTFOUND;
}

int register_entry(void *object, void *function){
	int i;
  for(i=0; display_table[i].obj!=NULL && i<N; i++);
	if (i>=N) return FULL;
	display_table[i].obj=object;
	display_table[i].fun=function;
}

void displaychar(char *c){
	printf("%c\n", *c);
}

void displayint(int *i){
	printf("%d\n", *i);
}

void displaystring(char *s){
	printf("%s\n", s);
}

int main(int argc, char **argv){
	register_entry(&argc,displayint);
	register_entry(argv[0],displaystring);
	display(&argc);
	display(argv[0]);
}
