/*
 * Simple vararg example
 */
#include <stdarg.h>
#include <stdio.h>
 
double avg(int n,...){
	va_list args; /* variable argument list definition */
	va_start(args, n); /* list scan initialization */
	int i;
	double sum=0;
	for(i=0; i<n; i++) 
		sum += va_arg(args,double); /* arg list scan */
	va_end(args); /* list scan completion */
	return sum/n;
}

#define print(x) printf("%s=%f\n", #x, x)

int main(int argc, char **argv){
	print(avg(2,1.3,1.5));
	print(avg(5,1.3,1.5,3.0,0.001,1.1));
}
