#ifndef _DEBUG_H
#define _DEBUG_H
#include <stdio.h>
#include <errno.h>

#define dbg() fprintf(stderr, "debug: %s %s %d\n", __FILE__,__FUNCTION__,__LINE__)

#define errorlog(status,err) if (status==err) errprint(__FILE__,__FUNCTION__,__LINE__, 1)

#define errlog(status) errorlog(status,-1)

#define eagain(status) (status==-1 && errno==EAGAIN) 


void errprint(const char *file, const char *function, int line, int ext);

#endif /* _DEBUG_H */
