#include <stdio.h>
#include <stdlib.h>

/* elementi di una lista */
typedef struct Elem {
	char *targa;
	struct Elem *next;
} Auto;

/* lista */
typedef Auto* Lista;

Lista autoInCentro;
FILE *pra;
FILE *permessi;
FILE *multe;

int search(Lista autoInCentro, char *targa){
	if (autoInCentro==0) return 0;
	if (strcmp(autoInCentro->targa, targa)==0) return 1;
	return search(autoInCentro->next, targa);
}

Lista insert(Lista autoInCentro, char *targa){
	Auto *new=malloc(sizeof(Auto));
	new->targa=targa;
	new->next=autoInCentro;
	return new;
}

/*
 targa
 Nome Cognome
 Modello
 */
int search_in_file(FILE *file, char *targa){
	char buf[256];	
	char *res;	
	while(1) {
		res=fgets(buf,255,file); /* Targa */
		if (res==0) { rewind(file); return 0; }
		buf[strlen(buf)-1]='\0'; /* Rimuove il '\n' alla fine della riga */
		if (strcmp(buf,targa)==0) { rewind(file); return 1; }
		res=fgets(buf,255,file); /* Proprietario */
		if (res==0) { rewind(file); return 0; }
		res=fgets(buf,255,file); /* Modello */
		if (res==0) { rewind(file); return 0; }
	}
}

int write_in_file(FILE *file, char *targa){
	fprintf(file,"%s\n",targa); 
}


/*
 Inserire targa in Lista autoInCentro
 Se la targa e' gia' presente, segnala un errore
 Verifica in un file "pra.txt" la presenza della targa
 Controlla se la targat e' presente nel file "permessi.txt"
 In caso contrario, inserisce la targa nel file "multe.txt"
*/

int ingresso(char *targa){
	int res;
	if(search(autoInCentro,targa)) {
		printf("Auto %s in ingresso gia' presente\n", targa);
		return -1;
	}
	
	autoInCentro=insert(autoInCentro,targa);
	res=search_in_file(pra,targa);
	if(res==0) {
		printf("Auto %s non registrata\n", targa);
		return -2;
	}
	res=search_in_file(permessi,targa);
	if(res==0) {
		return write_in_file(multe,targa);
	}
}

int main(int argc, char **argv){
	autoInCentro=0;
	pra=fopen("pra.txt","r");
	permessi=fopen("permessi.txt","r");
	multe=fopen("multe.txt","a");

	ingresso("00212234");
	ingresso("32148348");

	fclose(pra);
	fclose(permessi);
	fclose(multe);
}

