#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

int main(){
	pid_t pid; /* Id di processo: identifica in modo univoco il processo */
	/* Creo il nuovo processo */
	pid=fork(); /* Fork ritorna due volte! Una volta nel padre, una nel figlio*/
	/* Possiamo distinguere i due casi in base al valore del PID:
	 *   Nel padre:  pid==pid del figlio
	 *   Nel figlio: pid==0
	 */
	if (pid==0) { /* Siamo nel processo figlio */
		printf("Processo figlio: %d; il padre e' %d\n", 
			getpid(), getppid()); 
			/* Notare come otteniamo i due pid*/
		exit(1);
	} else {
		int status=0;
		wait(&status);
		printf("Processo padre: %d; il figlio e' %d\n", 
			getpid(), pid);
			/* Notare come i due pid possano essere visti anche 
			 * dal padre, ma con metodi diversi */
		printf("Stato del figlio: %d\n", status/256);
	}
}
