#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Problema: Cercare un carattere in una stringa.
 *
 * Cerchiamo di velocizzare al massimo la ricerca, supponendo di avere 
 * molti processori a disposizione.
 *
 * string: puntatore alla stringa 
 * inizio: indice del primo carattere da tenere in considerazione
 * fine:   indice del primo carattere da non tenere in considerazione
 * key:    carattere cercato
 */
int search(char *string, int inizio, int fine, char key){
	/*
		Partiamo dalla ricerca binaria su array, in forma ricorsiva:

		Caso base
		Se inizio==fine-1 : ritorna key==string[inizio]
		
		Passo ricorsivo
		len=fine-inizio
			chiamata ricorsiva su: inizio -> inizio+len/2
			chiamata ricorsiva su: inizio+len/2 -> fine 

	*/
	if (inizio==fine-1) return (key==string[inizio]); /* Caso base */
	else {	/* Passo ricorsivo */
		int hlen=(fine-inizio)/2;
		int status, res;
		int pid;
		/* Crea il primo processo figlio */
		pid=fork();
		if (pid==0) {
			printf("Starting %d on %d-%d\n", 
				getpid(), inizio, inizio+hlen);
			/* Prima chiamata ricorsiva */
			exit(search(string, inizio, inizio+hlen, key));
			/* Termine del primo processo figlio */
		}
		/* Crea il secondo processo figlio */
		pid=fork();
		if (pid==0) {
			printf("Starting %d on %d-%d\n", 
				getpid(), inizio+hlen, fine);
			/* Seconda chiamata ricorsiva */
			exit(search(string, inizio+hlen, fine, key)); 
			/* Termine del secondo processo figlio */
		}
		/* Not all the bits of status are used to hold the exit value:
		 * the exit value is cut at status&0377 (i.e., only the last 8 
		 * bits are returned).
		 * Macros are provided by the C library to check the exit value
		 */
		wait(&status); 
		if (!WIFEXITED(status)) {
			printf("A child of %d terminated incorrectly\n", 
				getpid());
			exit(1);
		}
		res=WEXITSTATUS(status);
		wait(&status);
		if (!WIFEXITED(status)) {
                        printf("A child of %d terminated incorrectly\n", 
				getpid());
                        exit(1);
                }
		res=res||(WEXITSTATUS(status));
		if (res>0)
			printf("Carattere trovato da %d\n", getpid());
		else
			printf("Carattere non trovato da %d\n", getpid());
		exit(res);
	}
}

int main(int argc, char **argv){
	pid_t pid;
	/* Credo il nuovo processo */
	char *string=argv[1]; /* Stringa */
	char c=argv[2][0]; /* Carattere */
	int len=strlen(string);

	if (search(string, 0, len, c)>0) 
		printf("Carattere trovato\n");	
	else
		printf("Carattere non trovato\n");
}

