#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

/* Problema: cercare un carattere in una stringa 
 * 
 * Il programma viene invocato come:
 *    ./a.out stringa c
 *
 * L'obiettivo e' ridurre il tempo di ricerca eseguendo meta' del lavoro in un 
 * processo figlio.
 */
int main(int argc, char **argv){
	pid_t pid;
	char *string=argv[1]; /* Stringa ottenuta come argomento */
	char c=argv[2][0]; /* Carattere ottenuto come secondo argomento */
	int len=strlen(string);
	int i;
	/* Creo il nuovo processo */
	pid=fork();
	if (pid==0) {
		printf("Processo figlio: %d; il padre e' %d\n", 
			getpid(), getppid());
		/* Cerco c nella prima meta' della stringa nel figlio */	
		for(i=0; i<len/2; i++)
			if (string[i]==c) exit(1); /* Notifico di aver trovato c*/
		/* Notifico di non aver trovato il carattere c */
		exit(0);
	} else {
		int status=0;
		printf("Processo padre: %d; il figlio e' %d\n", 
			getpid(), pid);
		printf("Stato del figlio: %d\n", status/256);
		/* Cerco c nella seconda meta' della stringa nel padre */
		for(i=len/2; i<len; i++)
			if (string[i]==c) {
				printf("Carattere trovato dal padre\n");
			}

		/* Prima di poter dire di non aver trovato il carattere, 
		 * devo attendere la terminazione del figlio: potrebbe 
		 * infatti averlo trovato lui! */
		wait(&status);
		if (status/256==1) { /* status <- valore di exit del figlio */
			printf("Carattere trovato dal figlio\n");
		} else
			printf("Carattere non trovato\n");
	}
}
