#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Cercare un carattere in una stringa */

int main(int argc, char **argv){
	pid_t pid;
	char *string=argv[1]; /* Stringa passata come primo argomento */
	char c=argv[2][0]; /* Carattere passato come secondo argomento */
	int len=strlen(string);
	int i,inizio, fine;
	int nchld=4;
	/* Stavolta usiamo 4 processi figli per accelerare ulteriormente 
	 * (ammesso ovviamente di avere 4 processori...)
	 */
	for(i=0; i<nchld; i++){
		inizio=i*len/4;
		fine=(i+1)*len/4;
		/* Creo il nuovo processo */
		pid=fork();
		if (pid==0) {
			printf("Processo %d: %d-%d\n", 
				getpid(), inizio, fine);
		
			for(i=inizio; i<fine; i++)
				if (string[i]==c) {
					printf("Carattere trovato da %d\n",
						getpid());
					exit(1);
				}
			printf("Carattere non trovato da %d\n", getpid());
			exit(0);
		}
	}	
	
	/* Dobbiamo attendere la terminazione di tutti e quattro i figli */
	for(i=0; i<nchld; i++){
		int status=0;
		wait(&status);

		if (status/256==1) {
			printf("Carattere trovato dal figlio\n");
			exit(1);
		} 
	}
	printf("Carattere non trovato\n");
	exit(0);
}
