#include <stdio.h>

void rimuovi_elemento(int a[], int n, int pos);

/*
 * Calcola la media di un array di interi
 *  Parametri:
 *    a     array di interi di cui calcolare la media
 *    n     lunghezza di a
 *  Ritorno: la media dei valori di a
 */
float media(int a[], int n){	
	int i;
	int somma=0;
	for(i=0; i<n; i++)
		somma+=a[i];
	return (float) somma/n;
}

/*
 * Trova, se esiste, il primo duplicato nell'array a
 *  Ritorno: la posizione del primo duplicato, o 0 se non c'e' 
 *           nessun duplicato
 */
int trova_duplicato(int a[], int n){
	int i, j;
	for(i=0; i<n; i++)
		for(j=0; j<i; j++)
			if (a[j]==a[i]) return i;
	return 0;
}

/*
 * Rimuove i duplicati da un array
 *  Ritorno: la lunghezza dell'array senza i duplicati
 */
int rimuovi_duplicati(int a[], int n){
	int m=n;
	int pos;
	while(1){
		pos=trova_duplicato(a,m);
		if (pos==0) return m;
		rimuovi_elemento(a,m,pos);
		m--;
	}
}

/*
 * Rimuove l'elemento in posizione pos dall'array
 */
void rimuovi_elemento(int a[], int n, int pos){
	int i;
	for(i=pos+1; i<n; i++)
		a[i-1]=a[i];
}


void stampa_array(int a[], int n){
	int i;
	for(i=0; i<n; i++){
		printf("%d ", a[i]);
	}
	printf("\n");
}


int main(){
	int array[10]= { 1, 2, 1, 4, 5, 6, 4, 8, 9, 4 };
	int n=10;

	stampa_array(array,n);
	n=rimuovi_duplicati(array,n);
	stampa_array(array,n);
	printf("Media = %f\n", media(array,n));
}
