#include <stdio.h>
#include <string.h>

#define TRUE 1
#define FALSE 0

/* Conta le occorrenze di s2 in s1
 * s1 stringa contenitore
 * s2 stringa contenuta
 * Risultato: numero di occorrenze di s2 in s1
 */
int conta_occorrenze(char *s1, char *s2);

/* Verifica se s2 e' un prefisso di s1
 * s1 stringa contenitore
 * s2 prefisso
 * Risultato: 1 se s2 e' un prefisso di s1, 0 altrimenti
 */
int prefisso(char *s1, char *s2);


int main(int argc, char **argv){
	int i;
	for(i=0; i<argc; i++)
		printf("%s\n",argv[i]);

	printf("\"%s\" e' contenuta in \"%s\" %d volte\n", 
		argv[2], 
		argv[1], 
		conta_occorrenze(argv[1],argv[2])
	);
}


int conta_occorrenze(char *s1, char *s2){
	int i, count=0;
	for(i=0; s1[i]!='\0'; i++)
		if(prefisso(&s1[i], s2)==TRUE)
			count++;	
	return count;
}


int prefisso(char *s1, char *s2){
	int i;
	if (strlen(s2)>strlen(s1)) return FALSE;
	for(i=0; s2[i]!='\0'; i++)
		if(s2[i]!=s1[i]) return FALSE;
	return TRUE;
}
