/*
 * Esercizi base sulla ricorsione
 */
#include <stdio.h>

int foo(int a){
	if (a<1) return 0;
	return foo(a-1)+1;
}

int fib(int n){
	if (n<2) return 1;
	return fib(n-1)+fib(n-2);
}

int fib_iter(int n){
	int n1, n2, i, tmp;
	if (n<2) return 1;
	n1=1;
	n2=1;
	for(i=2; i<=n; i++){
		tmp=n1;
		n1=n1+n2;
		n2=tmp;
	}
	return n1;
}

void loop(int m, int n, int step){
	int i;
	for(i=m; i<n; i=i+step){
		printf("%d\n", i);
	}
}

void loop_as_rec(int m, int n, int step){
	if (m<n) { /* traduce il controllo di permanenza nel ciclo */
		printf("%d\n", m); /* corpo del ciclo */
		loop_as_rec(m+step,n,step); /* incremento */
	} 
}

int main(int argc, char **argv){
	if(argc>=4) {
		loop(atol(argv[1]), atol(argv[2]), atol(argv[3]));
		loop_as_rec(atol(argv[1]), atol(argv[2]), atol(argv[3]));
		return 0;
	} else if (argc>1) {	
		int i;
		for(i=2; i<atol(argv[1]); i++)
			printf("%d\n", fib(i));
		for(i=2; i<atol(argv[1]); i++)
			printf("%d\n", fib_iter(i));
		return 0;
	}
	return -1;
}
