/* Esercizi con malloc e free */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
	char *nome;
	char *cognome;
} data;

void free_data(data *d){
	free(d->nome);
	free(d->cognome);
	free(d);
}

data *create_data(){
	data *new=malloc(sizeof(data));
	new->nome=0;
	new->cognome=0;
	return new;
}


data *read_data(FILE *f){
	char nome[100];
	char cognome[100];
	data *res=malloc(sizeof(data));
	res->nome=0; /* (*res).nome */
	res->cognome=0;
	fscanf(f, "%s", nome);
	fscanf(f, "%s", cognome);
	res->nome=malloc(sizeof(char)*(strlen(nome)+1));
	res->cognome=malloc(sizeof(char)*(strlen(cognome)+1));
	strcpy(res->nome,nome);
	strcpy(res->cognome,cognome);
	return res;
}


char *strdup1(char *s){
	int l=strlen(s);
	char *res=malloc((l+1)*sizeof(char));
	strcpy(res,s);
	return res;
}


int main(int argc, char **argv){
	char *s2=strdup1(argv[1]);
	data *d=0;
	FILE *f;
	printf("orig: %s\n", argv[1]);
	printf("dup: %s\n", s2);
	free(s2);	
	printf("dopo deallocazione: %s\n", s2); /* risultato non definito */
	f=fopen(argv[2],"r");
	d=read_data(f);
	fclose(f);
	/*
	 free(d->nome);
	 free(d->cognome);
	 free(d);
	 */
	free_data(d);
	/* Errore di accesso a memoria */
	s2=0;
	strcpy(s2,argv[1]);
}
