/*
 * Agenda
 */
typedef struct {
	short int giorno;
	short int mese;
	short int anno;
} data;

data *create_data(int giorno, int mese, int anno){
	data *res=malloc(sizeof(data));
	res->giorno=giorno;
	res->mese=mese;
	res->anno=anno;
	return res;
}

void free_data(data *d){
	free(d);
}

typedef struct {
	char *nome;
	char *cognome;
	data *nascita;
	char *luogo;
} persona;

persona *create_persona(char *nome, char *cognome, data *nascita, char *luogo){
	persona *res=malloc(sizeof(persona));
	res->nome=nome;
	res->cognome=cognome;
	res->nascita=nascita;
	res->luogo=luogo;
	return res;
}

void free_persona(persona *p){
	free(res->nome);
	free(res->cognome);
	free(res->luogo);
	free_data(res->nascita);
}


typedef struct _appuntamento {
	persona *paziente;
	short int ora;
	struct _appuntamento *next;
} appuntamento;

appuntamento *create_appuntamento(persona *paziente, short int ora){
	appuntamento *res=malloc(sizeof(appuntamento));
	res->paziente=paziente;
	res->ora=ora;
	res->next=0;
	return res;
}

void insert_appuntamento(appuntamento *lista, appuntamento *a){
	appuntamento *curr;
	/* Trova l'ultimo elemento della lista */
	for(curr=lista; curr->next!=0; curr=curr->next);
	curr->next=a;
}

appuntamento *search_appuntamento(appuntamento *lista, short int ora){
	if (lista==0) return 0;
	if (lista->ora==ora) return lista;
	return search_appuntamento(lista->next);
}

appuntamento *search_appuntamento_by_paziente(appuntamento *lista, 
					      persona *paziente){
	appuntamento *curr;
	for(curr=lista; curr!=0; curr=curr->next){
		if (curr->paziente==paziente) return curr;
	}
	return 0;
}

void free_lista_appuntamento(appuntamento *lista){
	free_persona(lista->paziente);
	if (lista->next!=0)
		free_lista_appuntamento(lista->next);
	free(lista);
}

typedef struct {
	data *giorno;
	appuntamento *lista_app;
} app_giorno;

app_giorno agenda[365];


