#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_AMICI 10

typedef struct _elem {
	char *nome;
	struct _elem *amici[MAX_AMICI];
	int namici;
	int mark;
	struct _elem *next;
} elem;

elem *insert(elem *l, char *nome){
	elem *res=malloc(sizeof(elem));
	res->nome=strdup(nome);
	res->namici=0;
	res->next=l;
	res->mark=0;
	return res;
}

elem *search(elem *l, char *nome){
	if (l==NULL) return NULL;
	if (strcmp(l->nome,nome)==0) return l;
	return search(l->next, nome);
}

int amici(elem *l, char *nome1, char *nome2){
	elem *p1=search(l,nome1);
	elem *p2=search(l,nome2);
	if (!p1 || !p2) return 1;
	p1->amici[p1->namici]=p2;
	p1->namici++;
	p2->amici[p2->namici]=p1;
	p2->namici++;
	return 0;
}

void reset_mark(elem *l){
	if (l==NULL) return;
	l->mark=0;
	reset_mark(l->next);
}

void mark_chiusura_transitiva(elem *a){
	int i;
	if (a->mark) return;
	a->mark=1;
	for(i=0; i<a->namici; i++)
		mark_chiusura_transitiva(a->amici[i]);
}

void print_chiusura_transitiva(elem *l, char *nome){
	elem *a=search(l,nome);
	if (!a) return;
	mark_chiusura_transitiva(a);
	a->mark=0;
	for(a=l; a!=NULL; a=a->next)
		if (a->mark) printf("\t%s\n", a->nome);
	reset_mark(l);
}

int main(){
	elem *l=NULL;
	l=insert(l,"A");
	l=insert(l,"B");
	l=insert(l,"C");
	l=insert(l,"D");
	l=insert(l,"E");
	l=insert(l,"F");
	amici(l,"A","B");
	amici(l,"C","B");
	amici(l,"C","D");
	amici(l,"E","F");
	amici(l,"A","D");
	printf("Amici di A:\n");
	print_chiusura_transitiva(l,"A");
	printf("Amici di F:\n");
	print_chiusura_transitiva(l,"F");
}
