#include <stdio.h>
#include <string.h>
#include <stdlib.h>
/*! \brief Pila (elemento) 
 *  E' una normale lista, con inserimento e cancellazione solo in testa
 */
typedef struct _elem {
	char c;
	struct _elem *next;
} elem;

/*! \brief Inserimento in testa */
elem *push(elem *pila, char c){
	elem *res = malloc(sizeof(elem));
	res->c=c;
	res->next=pila;
	return res;	
}

/*! \brief Legge il valore in testa */
char top(elem *pila){
	return pila->c;
}

/*!\brief Rimuove e dealloca l'elemento in testa */
elem *pop(elem *pila){
	elem *res=pila->next;
	free(pila);
	return res;
}

/*! \brief Controlla se la pila e' vuota o no */
int empty(elem *pila){
	return pila==NULL;
}

/*! \brief Stampa il contenuto della pila */
void print_pila(elem *pila){
	if (empty(pila)) {
		printf("\n");
		return;
	}
	printf("%c -> ", pila->c);
	print_pila(pila->next);
}

int main(int argc, char **argv){
	char *s;
	int i;
	elem *pila=NULL;
	if(argc<2) return 0;
	s=argv[1];
	printf("%c  %c  %c  %c   %c   %c   %c   %c\n", 
		'(', ')', '[', ']', '{', '}', '<', '>');
	printf("%d %d %d %d %d %d %d %d\n", 
		'(', ')', '[', ']', '{', '}', '<', '>');
	for(i=0; i<strlen(s); i++){
		printf("Leggo %c, pila: ", s[i]);
		print_pila(pila);
		switch(s[i]){
			case '<': /* Esegue fino al primo break! */
			case '{': 
			case '[':
			case '(': pila=push(pila,s[i]); break;
			case '>':
			case ']':
			case '}': s[i]=s[i]-1; /* s[i] deve diventare la parentesi aperta corrispondente */
			case ')': s[i]=s[i]-1;
				  if (!empty(pila) && top(pila)==s[i]) 
					pila=pop(pila); 
				  else {
					printf("Stringa non ben parentesizzata!\n");
					return 1;
				  }
				  break;
			default : break;
		}
	}
	if (empty(pila)) {
		printf("Stringa ben parentesizzata!\n");
		return 0;
	} else {
		printf("Stringa non ben parentesizzata!\n");
		return 0;
	}
}
