#include <stdio.h>
#include <stdlib.h>

#define TYPE int
#define TYPE_DESC d

typedef struct _elem {
	TYPE data;
	struct _elem *next;
	struct _elem *prev;
} elem;

typedef struct _lista {
	elem *head;
	elem *tail;
} lista

void print_lista(elem *l);

elem *create_elem(TYPE data){
	elem *res=malloc(sizeof(elem));
	res->data=data;
	res->next=0;
	res->prev=0;
}

void free_elem(elem *e){
	free(e);
}

lista *create_lista(){
	lista *res=malloc(sizeof(lista));
	res->head=0;
	res->tail=0;
	return res;
}

void free_lista(lista *l){
	elem *e=l->head;
	if (e->next!=0) free_lista(e->next);
	free_elem(e);
}

lista *conc_lista(lista *l1, lista *l2){
	elem *curr;
	l1->tail->next=l2->head;
	l1->tail=l2->tail;
	free(l2);
	return l1;
}

lista *insert_in_order(lista *l, elem *e){
	elem *curr=0;
	elem *prec=0;
	
	for(curr=l->head; curr!=0 && curr->data < e->data; curr=curr->next);
	prec=curr->prev;	

	/* Esegui inserimento */
	if (prec==0) { /* curr == l, inserimento in testa */
		e->next=l->head;
		l->head->prev=e;
		l->head=e;
		return l;
	} else { /* in posizione diversa dalla testa, fra prec e curr */
		prec->next=e;
		e->next=curr;
		e->prev=prec;
		return l;
	}
}

/* TODO */
lista *sort_lista(lista *l){
	elem *res;	
	if (l->head->next==0) return l;
	res=sort_lista(l->next);
	print_lista(res);
	l->next=0;
	return insert_in_order(res, l);
}

lista *insert_in_testa(lista *l, TYPE data){
	elem *curr=create_elem(data);
	if (l!=0) l->head->prev=curr;
	curr->next=l->head;
	l->head=curr;
	return l;
}

void print_lista(elem *l){
	if (l==0) {
		printf("\n");
	} else {
		printf("%TYPE_DESC ", l->data);
		print_lista(l->next);
	}
}

lista *insert_in_coda(lista *l, TYPE data){
	elem *curr;
	curr=create_elem(data);
	if (l->tail==0) { /* lista vuota */
		l->tail=curr;
		l->head=curr;
	} else {
		l->tail->next=curr;
		curr->prev=l->tail;
		l->tail=curr;
	}
	return l;
}

lista *delete_from_lista(lista *l, elem *e){
	elem *curr;
	if (l->head==0) return l;
	if (l->head==e) {
		l->head=e->next;
		e->next->prev=0;
		free_elem(e);
		return l;
	} 
	if (l->tail==e) {
		l->tail=e->prev;
		e->prev->next=0;
		free_elem(e);
		return l;
	}
	e->prev->next=e->next;
	e->next->prev=e->prev;	
	free_elem(e);
	return l;
}

elem *search_lista(elem *l, TYPE data){
	if (l==0) return 0;
	if (l->data==data) return l;
	return search_lista(l->next, data);
}

int main(int argc, char **argv){
	elem *curr;
	lista *l=create_lista();
	l=insert_in_testa(l,10);
	l=insert_in_testa(l,5);
	l=insert_in_testa(l,11);
	l=insert_in_testa(l,7);
	l=insert_in_testa(l,2);
	print_lista(l);
}
