#include <stdio.h>
#include <string.h>
#define BUFSIZE 128

int read(char buffer[]){
	return scanf("%s", buffer);
}

void store_frequencies(int freq[26], char buffer[]){
	int i;
	int len=strlen(buffer);
	for(i=0; i<len; i++){
		if (buffer[i]>='a' && buffer[i]<='z')
			freq[buffer[i]-'a']+=1;
		if (buffer[i]>='A' && buffer[i]<='Z')
			freq[buffer[i]-'A']+=1;
	}
	return;
}

void print_frequencies(int freq[26]){
	int i;
	int total=0;
	int permille[26];
	for(i=0; i<26; i++) total+=freq[i];
	for(i=0; i<26; i++) permille[i]=(freq[i]*1000)/total;
	printf("int frequency[26]={ ");
	for(i=0; i<25; i++) printf("%d, ", permille[i]);
	printf("%d };\n", permille[i]);
	return;
}

void init_frequencies(int freq[26]){
	int i;
	for(i=0; i<26; i++) freq[i]=0;
}

int max(int array[26]){
	int max=-1;
	int max_el=-1;
	int i;
	for(i=0; i<26; i++)
		if (max<array[i]) { 
			max=array[i];
			max_el=i;
		}
	return max_el;
}

void sort(int freq[26], char res[26]){
	int i;
	for(i=0; i<26; i++){
		int max_el=max(freq);
		freq[max_el]=-1;
		res[i]=max_el+'a';
	}
}

void print_sorted_array(char array[26], char name[]){
	int i;
	printf("char %s[26]={ ", name);
	for(i=0; i<25; i++){
		printf("'%c', ", array[i]);
	}	
	printf("'%c' };\n", array[i]);
}


int main(int argc, char **argv){
	int len=0;
	int frequencies[26];
	char buffer_in[BUFSIZE];
	char sorted_text[26];
	
	init_frequencies(frequencies);
	do {
		len=read(buffer_in);
		store_frequencies(frequencies,buffer_in);
	} while (len>=0);
	print_frequencies(frequencies);

	sort(frequencies,sorted_text);
	print_sorted_array(sorted_text,argv[1]);
}
