#include <stdio.h>
#include <string.h>
#define BUFSIZE 128

int read(char buffer[]){
	return scanf("%s", buffer);
}

void store_frequencies(int freq[25], char buffer[]){
	int i;
	int len=strlen(buffer);
	for(i=0; i<len; i++){
		if (buffer[i]>='a' && buffer[i]<='z')
			freq[buffer[i]-'a']+=1;
		if (buffer[i]>='A' && buffer[i]<='Z')
			freq[buffer[i]-'A']+=1;
	}
	return;
}

void print_frequencies(int freq[25]){
	int i;
	int total=0;
	int permille[25];
	for(i=0; i<25; i++) total+=freq[i];
	for(i=0; i<25; i++) permille[i]=(freq[i]*1000)/total;
	for(i=0; i<25; i++) printf("freq('%c')=%d per mille\n", 'a'+i, permille[i]);
}

void init_frequencies(int freq[25]){
	int i;
	for(i=0; i<25; i++) freq[i]=0;
}

int main(int argc, char **argv){
	int len=0;
	int frequencies[25];
	char buffer_in[BUFSIZE];
	init_frequencies(frequencies);
	do {
		len=read(buffer_in);
		store_frequencies(frequencies,buffer_in);
	} while (len>=0);
	print_frequencies(frequencies);
}
