#include "actions.h"
#include "printer.h"

/*! \brief Move position according to direction command */
void move_pos(int *row, int *col, command dir);

/*! \brief Implements the NOCMD action; also serves as default action */
void action_none(Level *level, character *pc);

/*! \brief Implements all the move actions, includes check for occupied space */
void action_move(Level *level, character *pc, command cmd);

void action(Level *level, character *pc, command cmd){
	switch (cmd) {
		case NOCMD:   action_none(level, pc); break;
		case UP:	    /* All move actions implemented by the same function */
		case DOWN:    
		case LEFT:    
		case RIGHT:   
		case UPLEFT:  
		case UPRIGHT: 
		case DWLEFT:  
		case DWRIGHT: action_move(level, pc, cmd); break;
		case PICK:    /*! \todo PICK not yet implemented */
		case DROP:    /*! \todo DROP not yet implemented */ 
		case ATTACK:  /*! \todo ATTACK not yet implemented */
		case FIRE:    /*! \todo FIRE not yet implemented */
		case CAST:    /*! \todo CAST not yet implemented */
		case EAT:     /*! \todo EAT not yet implemented */
		case READ:    /*! \todo READ not yet implemented */
		case USE:     /*! \todo USE not yet implemented */
		case SAVE:    /*! \todo SAVE not yet implemented */
		case REST:    /*! \todo REST not yet implemented */
		case QUIVER:  /*! \todo QUIVER not yet implemented */
		case WIELD:   /*! \todo WIELD not yet implemented */
		default : action_none(level, pc);
	}
}

void action_none(Level *level, character *pc){
	/* empty on purpose */
}

void action_move(Level *level, character *pc, command cmd){
	int row=pc->row;
	int col=pc->col;
	occupation state;
	move_pos(&row,&col,cmd);
	state = can_move_to(level, row, col);
	switch (state) {
		case BUSY: print_msg("Cannot move there..."); break;
		case FREE: pc->row=row; pc->col=col; break;
		case ATCK: print_msg("Attacks not yet implemented"); break;
	}
}

void move_pos(int *row, int *col, command dir){
	switch (dir) {
		case UP:	    *row-=1; break;
		case DOWN:    *row+=1; break;
		case LEFT:    *col-=1; break;
		case RIGHT:   *col+=1; break;
		case UPLEFT:  *row-=1; *col-=1; break;
		case UPRIGHT: *row-=1; *col+=1; break;
		case DWLEFT:  *row+=1; *col-=1; break;
		case DWRIGHT: *row+=1; *col+=1; break;
	}	
}

