#include "level.h"
#include <stdio.h>
#include <string.h>
#include "utils.h"
#include "printer.h"

Level *load_level_map(char *filename){
	int i, nchars;
	FILE *fin=open_file(filename,"r");
	Level *level=dmalloc(sizeof(Level));

	/* Read n cols and n rows from file */
	fscanf(fin,"%d\n%d\n", &(level->rows), &(level->cols));
	level->map=dmalloc(sizeof(char *)*level->rows);
	
	for(i=0; i<level->rows; i++){
		level->map[i]=dmalloc(sizeof(char *)*level->cols);
		nchars=fscanf(fin,"%s\n", level->map[i]);
		if(nchars<1 || strlen(level->map[i])<level->cols) {
			fprintf(stderr,"Read error at line %d (rows: %d, cols: %d): %s\n", i, 
							level->rows, level->cols, level->map[i]);
			fprintf(stderr,"Items read: %d; string length: %d\n", nchars, 
							(int)strlen(level->map[i]));
			return NULL;		
		}
	}
	return level;
}

Level *load_level(char *filename){
	int i, depth, end=1;
	char buf1[128];
	char buf2[128];
	Level *level=NULL;
	FILE *fin=open_file(filename, "r");

	fscanf(fin,"name:%s\n",buf1);
	fscanf(fin,"depth:%d\n",&depth);
	fscanf(fin,"map:%s\n", buf2);
	level=load_level_map(buf2);
	
	level->depth=depth;
	level->objs=dmalloc(sizeof(content)*MAXITEMS);
	reset(level->objs,sizeof(content)*MAXITEMS);
		
	return level;
}

void print_level(Level *level, int row, int col, char pcsymbol){
	char **map;
	int i;
	/*! Create memory for the map and copy the base map from level */
	map=dmalloc(sizeof(char *)*level->rows);
	for(i=0; i<level->rows; i++){
		map[i]=strdup(level->map[i]);
	}
	/*! Add the symbol corresponding to the PC */
	map[row][col]=pcsymbol;
	
	/*! Print out the map using the printer.h facilities */
	print_map(map, level->rows);
	
	/*! Deallocate the memory used for the map */
	for(i=0; i<level->rows; i++){
		dfree(map[i]);
	}
	dfree(map);
}

occupation can_move_to(Level *level, int row, int col){
	if (level->map[row][col]!='.') return BUSY;
	/*! \todo Check if monsters are present, in that case return ATCK */
	return FREE;
}




#ifdef TEST_LEVEL
void print_end(char *s) {
	#ifdef CURSES
		refresh();
		napms(1000);
		mvprintw(LINES-1, COLS-11,s); 
		refresh();
		napms(1000);
	#endif /* CURSES */
}

int main(int argc, char **argv){
	Level *level;
	
	screen_init();
	level=load_level(argv[1]);
	print_level(level,8,2,'@');
	print_end("Curses Test");
	screen_close();
	
	#ifdef CURSES
		printf("Test finished with curses\n");
	#else
		printf("Test finished without curses\n");
	#endif /* CURSES */
}
#endif /* TEST_LEVEL */
