#ifndef PRINTER_H
#define PRINTER_H
/*! \file printer.h
 *  \brief Printing facilities with both cursesh and stdio.h
 *
 *  Note there is no support for Windows.
 *  \todo Implement conio.h support within ifdef macro using
 *        __WIN32 / __WIN64 macros to detect Windows
 */
#include "window.h"

/*! Print messages to the user */
#ifdef CURSES
	#include <ncurses.h>
	#define print_msg(FORMAT, ...) mvprintw(MSG_ROW,MSG_COL,FORMAT, ##__VA_ARGS__); clrtoeol(); refresh();
#else
#ifdef CONIO
	/* This stuff is untested! */
	#include <conio.h>
	#define print_msg(FORMAT, ...) gotoxy(MSG_COL,MSG_ROW); cprintf(FORMAT, ##__VA_ARGS__); 
#else
	#include <stdio.h>
	#define print_msg(FORMAT, ...) fprintf(stdout, FORMAT "\n", ##__VA_ARGS__); 
#endif /* CONIO */
#endif /* CURSES */

/*! Initialize printing facilities */
void screen_init();
/*! Finalize printing facilities */
void screen_close();

/*! Generic printer of an array of nrows strings 
 *
 *  Curses: Starts printing from position (0, col) 
 */
void print_strings(char **strings, int nrows, int col);

/*! Print a level map with nrows rows
 *
 *  Curses: Starts printing at (0,0) 
 */
void print_map(char **map, int nrows);

#endif /* PRINTER_H */
