#ifndef WINDOW_H
#define WINDOW_H
/*! \file window.h
 *  \brief Configuration file.
 *
 * This file should contain only macro definitions.
 * These macros serve to configure the screen and other aspects of the game.
 */

/*! \name Window Structure 
 * Rows and Cols at which specific elements (NW corner) are located 
 *
 * \todo Positions at the bottom of the screen should be made relative
 *       to LINES and COLS (macros exported by ncurses.h), when in 
 *       CURSES mode.
 */
/**@{*/
/*! \brief Position of the message line, row */
#define MSG_ROW 24
/*! \brief Position of the message line, column */ 
#define MSG_COL 0 
/*! \brief Position of the character status box, row */
#define STATUS_ROW 0  
/*! \brief Position of the character status box, column */
#define STATUS_COL 43 
/*! \brief Position of the level map, row */
#define MAP_COL 0 
/*! \brief Position of the level map, column */
#define MAP_ROW 0
/*! \brief Position of the item/monster description line, row */
#define DESC_ROW 21
/*! \brief Position of the item/monster description line, column */
#define DESC_COL 0

/*! \brief Size of the character status box, rows */
#define COMPACT_TEXT_ROWS 6  
/*! \brief Size of the character status box, columns */
#define COMPACT_TEXT_COLS 37 
/**@}*/

/*! \brief Max string sizes */
#define MAX_NAME_LEN 64

/*! \name File names */
/**@{*/
/*! \brief Random names file */
#define NAMES_FILE "random_names.txt"
/**@}*/

#endif /* WINDOW_H */
