#ifndef LIST_H
#define LIST_H

/*! \brief A generic list structure.
 *
 *  void * is defined as void * to allow any kind of data to be stored
 */
typedef struct _elem {
	void * data;
	struct _elem *next;
} elem;

/*! \brief Create a new list node */
elem *create_elem(void * data);

/*! \brief Destroy a new list node */
void free_elem(elem *e);

/*! \brief Destroy entire list */
void free_list(elem *e);

/*! \brief Concatenate two lists */
elem *conc_list(elem *l1, elem *l2);

/*! \brief Insert element e in list l, in order
 * 
 *  Here the ordering must be determined through an external comparison
 *  function. Details of function pointers are beyond the scope of this
 *  course, but will be covered in 
 */
elem *insert_in_order(elem *l, elem *e, int (*cmp)(void * d1, void * d2));

/*! \brief Sort the list
 *
 * See insert_in_order for more on ordering.
 */
elem *sort_list(elem *l, int (*cmp)(void * d1, void * d2));

/*! \brief Insert new element at the beginning of the list */
elem *insert_head(elem *l, void * data);

/*! \brief Insert new element at the end of the list */
elem *insert_tail(elem *l, void * data);

/*! \brief Remove a given element from the list */
elem *delete_from_list(elem *l, elem *e);

/*! \brief Find the element containing a given data item */
elem *search_list(elem *l, void * data, int (*cmp)(void * d1, void * d2));

#define insert(l, d) l=insert_head(l,(void *)d)
#define delete(l, e) l=delete_from_list(l, e)
#define sort(l,cmp)  l=sort_list(l, cmp)

#endif /* LIST_H */
