#include "printer.h"
#include <errno.h>
#include <stdlib.h>

#ifdef CURSES
	#define print_row(R,X) mvprintw(R,0,"%s", X); refresh()
	#define print_rowat(R,C,X) mvprintw(R,C,"%s", X); refresh()
#else
#ifdef CONIO
	/* Warning! conio support has never been tested! */
	#define print_row(R,X) gotoxy(0,R); cprintf("%s", X)
	#define print_rowat(R,C,X) gotoxy(C,R); cprintf("%s\n", X)
#else
	#define print_row(R,X) printf("%s", X)
	#define print_rowat(R,C,X) printf("%s\n", X)
#endif /* CONIO */
#endif /* CURSES */

void screen_init(){
#ifdef CURSES
	WINDOW *win =	initscr();
	noecho();
	if (!win) {
		perror("Window initialization error");
		exit(errno);
	}
	keypad(win,1);
#endif /* CURSES */
}

void screen_close(){
#ifdef CURSES
	endwin();
#endif /* CURSES */
}

void print_map(char **map, int nrows) {
	print_strings(map, nrows, MAP_COL);
}

void print_strings(char **strings, int nrows, int col) {
	int i;
	for(i=0; i<nrows; i++)
		print_rowat(i,col,strings[i]);
}
