#include "commands.h"
#include "printer.h"

#define NCMD 22

command cmds[NCMD] = { NOCMD,	UP,	DOWN, LEFT, RIGHT, UPLEFT, 
											 UPRIGHT, DWLEFT, DWRIGHT, PICK, DROP, 
											 ATTACK, FIRE, CAST, EAT, READ, USE, 
											 SAVE, REST, QUIVER, WIELD };

/*! \brief Handle curses or stdio to get one character
 *
 *  This function is not exposed to the rest of the program
 *  and must be therefore called only from other functions
 *  in this file.
 */
command get_cmd(){
		int cmd, cmd2;
		#ifdef CURSES
			move(MSG_ROW,MSG_COL); /*! Position the cursor to the message row */
			cmd=getch(); /*! Read a single character */
			insertln(); /*! Hide the character just read */
		#else 
			cmd=getchar();	
			cmd2=getchar();
		#endif /* CURSES */
		return cmd;
}
										 
command get_command(){
	int cmd=0;
	int i;
	while(!cmd) {
		cmd=get_cmd();
		for(i=0; i<NCMD; i++)
			if (cmd==cmds[i]) return cmd;
		print_msg("Command '%c' unrecognized, enter new command", cmd);
		cmd=0;
	}
}

command get_move_command(){
	int cmd=0;
	while(1) {
		cmd=get_cmd();
		switch (cmd) {
			case UP:
			case DOWN:    
			case LEFT:    
			case RIGHT:   
			case UPLEFT:  	
			case UPRIGHT: 
			case DWLEFT:  
			case DWRIGHT: return cmd;
			default : print_msg("Not a valid direction!"); break;
		}
	}
}

int get_yes_no(){
	int cmd=0, cmd2;
	int i;
	while(!cmd) {
		cmd=get_cmd();
		if ((cmd=='y') || (cmd=='Y')) return 1;
		if ((cmd=='n') || (cmd=='N')) return 0;
		print_msg("Command '%c' unrecognized, enter new command", cmd);
		cmd=0;
	}
	/*! Unreacheable */
}

#ifdef TEST_COMMANDS
int main(){
	command cmd=0;
	screen_init();
	while(cmd!=SAVE){
		cmd=get_command();
		print_msg("Entered command %d = %c ('s' to end)",cmd,cmd);
		#ifdef CURSES
			move(MSG_ROW,MSG_COL);
		#endif
	}
	screen_close();
}
#endif /* TEST_COMMANDS */
