#include "direction.h"

direction dir_to(int x0, int y0, int x1, int y1){
	int dx, dy, sx, sy;
	dx = x1-x0;
	dy = y1-y0;
	if (dy>0 && dx==0) return NORTH;
	else if (dy>0 && dx>0) return NORTHEAST;
	else if (dy==0 && dx>0) return EAST;
	else if (dy<0 && dx>0) return SOUTHEAST;
	else if (dx==0 && dy<0) return SOUTH;
	else if (dy<0 && dx<0) return SOUTHWEST;
	else if (dy==0 && dx<0) return WEST;
	else if (dy>0 && dx<0) return NORTHWEST;
	/*! TODO */
	return INVDIR; /* Some error... */
}

direction reverse_dir(direction dir){
	return NORTH+(dir+3)%8;
}


#ifdef TEST_DIRECTION
#include <stdio.h>

int main(){
	int x0, x1, y0, y1;
	char *dirs[9]= { "INVDIR", "NORTH", "NORTHEAST", "EAST", 
	              "SOUTHEAST", "SOUTH", "SOUTHWEST", "WEST", "NORTHWEST" };
	direction dir=INVDIR;
	for(dir=NORTH; dir<=NORTHWEST; dir++){
		printf("reverse of %s -> %s\n", dirs[dir], dirs[reverse_dir(dir)]);
	}
	x0=3; y0=3; 
	x1=5; y1=7;
	printf("To go from (%d,%d) to (%d,%d), you need to go %s\n", 
	       x0,y0, x1,y1, dirs[dir_to(x0,y0,x1,y1)]);
	x1=1; y1=2;
	printf("To go from (%d,%d) to (%d,%d), you need to go %s\n", 
	       x0,y0, x1,y1, dirs[dir_to(x0,y0,x1,y1)]);
	x1=3; y1=8;
	printf("To go from (%d,%d) to (%d,%d), you need to go %s\n", 
	       x0,y0, x1,y1, dirs[dir_to(x0,y0,x1,y1)]);
}
#endif /* TEST_DIRECTION */
