#include "utils.h"
#include "list.h"

elem *create_elem(void * data){
	elem *res=dmalloc(sizeof(elem));
	res->data=data;
	res->next=0;
}

void free_elem(elem *e){
	dfree(e);
}

void free_list(elem *e){
	if (e->next!=0) free_list(e->next);
	free_elem(e);
}

elem *conc_list(elem *l1, elem *l2){
	elem *curr;
	if (l1==0) return l2; /* necessaria per evitare curr->next su 0 */
	if (l2==0) return l1; /* per performance */
	for(curr=l1; curr->next!=0; curr=curr->next);
	curr->next=l2;
	return l1;
}

elem *insert_in_order(elem *l, elem *e, int (*cmp)(void * d1, void * d2)){
	elem *curr=0;
	elem *prec=0;
	
	/* Cerca la posizione per l'inserimento */
	for(curr=l, prec=0;  /* posizione iniziale (in testa) */
	    (curr!=0) && (cmp(curr->data, e->data)<0); 
                             /* controllo (1) di non essere in coda e (2) 
                                se l'elemento corrente e' maggiore di quello
                                da inserire */
	    prec=curr, curr=curr->next) /* non c'e' corpo */;  
                             /* mantiene memoria dell'ultima posizione 
                                visitata */
	
	/* Esegui inserimento */
	if (prec==0) { /* curr == l, inserimento in testa */
		e->next=l;
		return e;
	} else { /* in posizione diversa dalla testa, fra prec e curr */
		prec->next=e;
		e->next=curr;
		return l;
	}
}

elem *sort_list(elem *l, int (*cmp)(void * d1, void * d2)){
	elem *res;	
	if (l->next==0) return l;
	res=sort_list(l->next, cmp);
	l->next=0;
	return insert_in_order(res, l, cmp);
}

elem *insert_head(elem *l, void * data){
	elem *curr=create_elem(data);
	curr->next=l;
	return curr;
}

elem *insert_tail(elem *l, void * data){
	elem *curr;
	if (l==0) return create_elem(data);
	for(curr=l; curr->next!=0; curr=curr->next);
	curr->next=create_elem(data);
	return l;
}

elem *delete_from_list(elem *l, elem *e){
	elem *curr;
	if (l==0) return 0;
	if (l==e) {
		curr=e->next;
		free_elem(e);
		return curr;
	}
	for(curr=l; curr!=0 && curr->next!=e; curr=curr->next);
	if (curr==0) return l; /* elemento non presente */
	curr->next=e->next; 
	free_elem(e);
	return l;
}

elem *search_list(elem *l, void * data, int (*cmp)(void * d1, void * d2)){
	if (l==0) return 0;
	if (cmp(l->data,data)==0) return l;
	return search_list(l->next, data, cmp);
}


#ifdef TEST_LISTS
#include <stdio.h>

int compare(void * d1, void * d2){
	if (d1>d2) return 1;
	if (d1==d2) return 0;
	return -1;
}

void print_list(elem *l){
	if (l==0) {
		printf("\n");
	} else {
		printf("%d ", (int)(l->data));
		print_list(l->next);
	}
}

int main(int argc, char **argv){
	elem *l=0, *curr;
	l=insert_head(l,(void *)10);
	l=insert_head(l,(void *)5);
	l=insert_head(l,(void *)11);
	l=insert_head(l,(void *)7);
	l=insert_head(l,(void *)2);
	print_list(l);
	l=sort_list(l, compare);
	print_list(l);
}
#endif /* TEST_LISTS */
