#include "monsters.h"
#include "utils.h"
#include "printer.h"

/*! A structure containing pre-defined monster types
 *  \todo Exercise: replace this structure with a dynamic one
 *  where information from a configuration file is loaded
 */
monster_type monster_types[NMONSTERTYPES+1] = {
                        /* mght,spd,mnd,hit,dmg */
  { NOMONST,'\0',"none",     0,  0,  0,  0,  0 },
	{ RAT,    'r', "rat",      3,  4,  2,  2,  1 },
	{ KOBOLD, 'k', "kobold",   6,  7,  6, 10,  2 }, 
	{ GOBLIN, 'g', "goblin",   8,  8,  6, 14,  3 }, 
	{ WOLF,   'w', "wolf",     9,  10, 4, 15,  3 }, 
	{ WYVERN, 'W', "wyvern",  12,  12, 6, 20,  4 }, 
	{ DRAGON, 'D', "dragon",  18,  10,18, 30,  6 }, 
	{ NMONSTERTYPES, '\0', "stop", 0, 0, 0, 0 }, 
};

monster *create_monster(monsters type){
	monster *res = dmalloc(sizeof(monster));
	res->species = &(monster_types[type]);
	res->hits = res->species->hits;
}

void destroy_monster(monster *m){
	dfree(m);
}

monsters get_monster_type_from_symbol(char sym){
	monsters i;
	for(i=NOMONST; i<NMONSTERTYPES; i++)
		if (monster_types[i].symbol==sym) return i;
	return NOMONST;
}

void monster_attack(monster *m, character *pc){
	int roll=d20();
	if (roll==1 || roll+character_melee_ranged_defense_bonus(pc)<m->species->might) {
		print_msg("The %s hits you for %d damage!", m->species->name, m->species->dmg);
		character_apply_damage(pc,m->species->dmg);
	} else {
		print_msg("The %s attacks you, but misses!", m->species->name);
	}
	pause(100); /* This prevents the text from being overwritten 
	             * before the player can read it */
}

int monster_xp(monster *m, character *pc){
	int m_level = m->species->hits/5;
	int pc_level= pc->level;
	if (m_level < pc_level - 2) return 0;
	if (m_level <= pc_level) return 1;
	return m_level-pc_level;
}

monster_action monster_ai(monster *m, character *pc, int distance){
	/* If the monster is badly damaged, it will flee if it is intelligent 
	 * or scared enough. Threshold is 20% HP */
	if ((m->hits<m->species->hits/5)  && (d20()<m->species->mind || d6(1)<m->species->dmg)) return MONSTER_FLEE;
	/* PC is NULL if the monster cannot see the PC */
	if (!pc) 
		if (d20()<11) return MONSTER_MOVE;
		else return MONSTER_REST;
	if (distance==1) return MONSTER_ATTACK;
	/* At this time, monsters do not have ranged attacks or spells... 
	 * \todo Account for monster ranged attacks and magic in monster AI
	 */
	return MONSTER_HUNT;
}
