#ifndef COMMANDS_H
#define COMMANDS_H
/*! \file commands.h
 *  \brief Definition of action commands 
 */
#ifdef CURSES
#include <ncurses.h>
#else
#include <stdio.h>
#endif /* CURSES */

/*! \brief Definition of possibly actions and the 
 *  corresponding one-character commands */
typedef enum {
	NOCMD=0,
#ifdef CURSES
	UP=KEY_UP,
	DOWN=KEY_DOWN,
	LEFT=KEY_LEFT,
	RIGHT=KEY_RIGHT,
	UPLEFT=KEY_HOME,
	UPRIGHT=KEY_PPAGE,
	DWLEFT=KEY_END,
	DWRIGHT=KEY_NPAGE,
#else
	UP='k',
	DOWN='j',
	LEFT='h',
	RIGHT='l',
	UPLEFT='y',
	UPRIGHT='u',
	DWLEFT='b',
	DWRIGHT='n',
#endif /* CURSES */
	PICK='g',
	DROP='d',
	ATTACK='a',
	FIRE='f',
	CAST='c',
	EAT='e',
	READ='r',
	USE='x',
	SAVE='s',
	REST='.',
	QUIVER='q',
	WIELD='w'
} command;

/*! \brief Get a command from input 
 *
 *  This function reads a command from the input.
 *  It includes minimal correctness control.
 *  \return The code corresponding to the command read.
 */
command get_command();

/*! \brief Get a movement command from input 
 *
 *  This function reads a command from the input.
 *  It checks that the command is a movement (direction) one.
 *  It is suitable for use in other actions that require a 
 *  direction (e.g., FIRE, ATTACK, CAST).
 *  \return The code corresponding to the direction read.
 */
command get_move_command();

/*! \brief Get a yes/no answer */
int get_yes_no();

#endif /* COMMANDS_H */
