#ifndef DIRECTION_H
#define DIRECTION_H

/*! \brief An enumeration of directions for attacks and movement actions
 */
typedef enum { INVDIR, NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST } direction;

/*! \brief Reverse of a direction 
 *  \param dir The direction of which we need to know the opposite 
 *  \return The opposite direction, computed as ((dir-NORTH)+4)%8+NORTH
 *  This is correct because:
 *   - Directions are consecutive
 *   - INVDIR = 0
 *   - So we remove INVDIR from the count, rebasing dir to 0.
 *   - Then the opposite to each direction is dir+4, computed modulo the number
 *     of directions
 *   - Finally, we need to rebase back to NORTH
 */
direction reverse_dir(direction dir);

/*! \brief Direction from (x0, y0) towards a given position (x1, y1) */
direction dir_to(int x0, int y0, int x1, int y1);

#endif /* DIRECTION_H */
