#include "enemyactions.h"
#include "printer.h"
#include <math.h>

content *find_monster_pos(Level *level, monster *m){
	int i;
	for(i=0; i<count_objs_in_level(level); i++)
		if (level->objs[i].valid==VALID && level->objs[i].npc==m)
			return &(level->objs[i]);
	return NULL;	
}

monster *find_monster_adjacent_to(Level *level, int pc_row, int pc_col){
	static direction dir;
	static int row;
	static int col;
	monster *res;
	/* Initialization */
	if (pc_row>=0 && pc_col>=0) {
		row=pc_row;
		col=pc_col;
		dir=NORTH;
	} 
	/* General operation */
	res=NULL;
	switch(dir){
		case NORTH:      res=find_monster_at(level, row-1,col  ); dir++; if (res) return res;
		case NORTHEAST : res=find_monster_at(level, row-1,col+1); dir++; if (res) return res;
		case EAST :      res=find_monster_at(level, row  ,col+1); dir++; if (res) return res;
		case SOUTHEAST : res=find_monster_at(level, row+1,col+1); dir++; if (res) return res;
		case SOUTH :     res=find_monster_at(level, row+1,col  ); dir++; if (res) return res;
		case SOUTHWEST : res=find_monster_at(level, row+1,col-1); dir++; if (res) return res;
		case WEST :      res=find_monster_at(level, row  ,col-1); dir++; if (res) return res;
		case NORTHWEST : res=find_monster_at(level, row-1,col-1); dir++; if (res) return res;
		default : return NULL;
	}
}

monster *get_next_active_monster(Level *level){
	static int i;
	static Level *l;
	monster *res;
	if (level!=NULL) {
		l=level;
		i=0;
	}
	while(i<count_objs_in_level(l))
		if (l->objs[i].valid==VALID && l->objs[i].npc!=NULL && l->objs[i].npc->turn==0) {
			i++;
			return l->objs[i-1].npc;
		} else {
			i++;
		}
	/*! No more monsters to return */
	return NULL;
}

int monster_LoS_to(Level *level, monster *m, int row, int col){
	content *pos=find_monster_pos(level, m);
	if (pos==NULL){
		print_msg("Uh oh, I seem to have lost track of a %s...", m->species->name);
		return;
	}
	return line_of_sight(level, pos->row, pos->col, row, col);
}

void move_monster_dir(Level *level, monster *m, direction dir){
	int x0, y0, x1, y1;
	content *pos=find_monster_pos(level, m);
	if (pos==NULL){
		print_msg("Uh oh, I seem to have lost track of a %s...", m->species->name);
		return;
	}
	x0=pos->row;
	y0=pos->col;
	switch(dir){
		case NORTH:      x1=x0; y1=y0+1; break;
		case NORTHEAST : x1=x0+1; y1=y0+1; break;
		case EAST :      x1=x0+1; y1=y0; break;
		case SOUTHEAST : x1=x0+1; y1=y0-1; break;
		case SOUTH :     x1=x0; y1=y0-1; break;
		case SOUTHWEST : x1=x0-1; y1=y0-1; break;
		case WEST :      x1=x0-1; y1=y0; break;
		case NORTHWEST : x1=x0-1; y1=y0+1; break;
		default : break;
	}
	if (can_move_to(level, x1, y1)==FREE) {
		pos->row=x1;
		pos->col=y1;
	}	
}

void move_monster_random(Level *level, monster *m){
	direction dir=randint(NORTH, NORTHWEST);
	move_monster_dir(level, m, dir);
}

/*! \brief Get the monster position and find the direction towards a goal */
direction monster_dir_to(Level *level, monster *m, int row, int col){
	content *pos=find_monster_pos(level, m);
	if (pos==NULL){
		print_msg("Uh oh, I seem to have lost track of a %s...", m->species->name);
		return;
	}
	return dir_to(pos->row, pos->col, row, col);
}

int monster_distance(Level *level, monster *m, int row, int col){
	content *pos=find_monster_pos(level, m);
	int dx, dy;
	if (pos==NULL){
		print_msg("Uh oh, I seem to have lost track of a %s...", m->species->name);
		return;
	}
	dx=pos->col-col;
	dx=dx*dx;
	dy=pos->row-row;
	dy=dy*dy;
	return (int) ceil(sqrt(dx+dy));
}

void monster_flee(Level *level, monster *m, int row, int col){
	direction dir = monster_dir_to(level, m, row, col);
	dir=reverse_dir(dir);
	move_monster_dir(level, m, dir);
}

void monster_goto(Level *level, monster *m, int row, int col){
	direction dir = monster_dir_to(level, m, row, col);
	move_monster_dir(level, m, dir);
}


void reset_monster_turns(Level *level){
	int i;
	for(i=0; i<count_objs_in_level(level); i++)
		if (level->objs[i].valid==VALID && level->objs[i].npc!=NULL)
			level->objs[i].npc->turn=0;
}
