#include "character.h"
#include "utils.h"
#include "window.h"
#include <string.h>
#include <stdio.h>

char_class pc_classes[NCLASSES] = {
	{ "Fighter", 3, 1, 0, 2, 1, 0, 3, 1, 0 },
	{ "Thief",   1, 3, 1, 1, 2, 0, 0, 3, 1 },
	{ "Wizard",  0, 0, 3, 0, 0, 3, 0, 1, 3 },
};

int character_might_bonus(character *pc){
	return (pc->cur_might-8)/3;
}

int character_speed_bonus(character *pc){
	return (pc->cur_speed-8)/3;
}

int character_mind_bonus(character *pc){
	return (pc->cur_mind-8)/3;
}

character_status character_get_status(character *pc){
	 character_status status=HALE;
	 if (pc->cur_might==0) status+=1;
	 if (pc->cur_speed==0) status+=1;
	 if (pc->cur_mind==0) status+=1;
	 return status;
}

int character_melee_attack_bonus(character *pc){
	/*! \todo Add effect of wielded magic weapon */
	return pc->class->att_melee + character_might_bonus(pc);
}

int character_melee_damage_bonus(character *pc){
	/*! \todo Add effect of wielded weapon */
	return pc->class->dmg_melee + character_might_bonus(pc);
}


character *random_create_player_character(){
	character *pc=dmalloc(sizeof(character));
	pc->name=random_name();
	pc->symbol='@';
	/* Statistics */
	pc->might=d6(2)+6;
	pc->speed=d6(2)+6;
	pc->mind=d6(2)+6;
	/* Current values */
	pc->cur_might=pc->might; 
	pc->cur_speed=pc->speed; 
	pc->cur_mind=pc->mind;  
	/* Progression */
	pc->class=&(pc_classes[randint(0,NCLASSES-1)]); 
	pc->level=1;  
	pc->xp=0;      
	/* Position */
	pc->dungeon=1;
	pc->row=11;
	pc->col=3;
	pc->turn=0;
	/* Equipment: max 25 object types (a-z) */
	pc->equipment[0]=create_item(SWORD,1,0,NULL,0);
	pc->equipment[1]=create_item(BOW,1,0,NULL,0);
	pc->equipment[2]=create_item(TOME,1,0,NULL,0);
	pc->equipment[3]=create_item(ARROW,10,0,NULL,0);
	return pc;
}

char **init_text_compact(){
	int i;
	char **res=dmalloc(sizeof(char *)*COMPACT_TEXT_ROWS);
	res[0]=dmalloc(sizeof(char)*MAX_NAME_LEN);
	for(i=1; i<COMPACT_TEXT_ROWS; i++)
		res[i]=dmalloc(sizeof(char)*COMPACT_TEXT_COLS);
	return res;
}

void destroy_text_compact(char **res){
	int i;
	for(i=0; i<COMPACT_TEXT_ROWS; i++)
		dfree(res[i]);
	dfree(res);
}

char **character_to_text_compact(char **res, character *pc){
	sprintf(res[0], "%s", pc->name);
	sprintf(res[1], "Level %d %s (%d xp)", pc->level, pc->class->name, pc->xp);
	sprintf(res[2], "Might %d of %d", pc->cur_might, pc->might);
	sprintf(res[3], "Speed %d of %d", pc->cur_speed, pc->speed);
	sprintf(res[4], "Mind  %d of %d\tTurn: %d", pc->cur_mind, pc->mind, pc->turn);
	return res;
}

#ifdef TEST_CHARACTER
int main(){
	character *pc;
	char **desc=init_text_compact();
	screen_init();
	init_random_generator();
	pc=random_create_player_character();
	debug("Converting to text");
	character_to_text_compact(desc,pc);
	debug("Printing");
	print_strings(desc,COMPACT_TEXT_ROWS,STATUS_COL);
	debug("Destroying data structure");
	destroy_text_compact(desc);
	debug("End of \"character.c\" test");
	#ifdef CURSES
		refresh();
		napms(2000);
	#endif /* CURSES */
	screen_close();
}
#endif /* TEST_CHARACTER */
