#ifndef MONSTERS_H
#define MONSTERS_H
/*! \file monsters.h
 *  \brief Description of monsters and their types
 */
 
 /*! \brief Enumerator of the monster types */
 typedef enum _monsters {
 	NOMONST,
	RAT,
	KOBOLD,
	GOBLIN,
	WOLF,
	NMONSTERTYPES
 } monsters;
 
 /*! \brief Monster type */
typedef struct _monster_type {
	monsters type;
	char symbol; /*! Should be replaced with an enum type */	
	char *name; /*! The monster type name */
	short int might; /*! Might Attack/Defense */
	short int speed; /*! Speed Attack/Defense */
	short int mind;  /*! Mind  Attack/Defense */
	short int hits;  /*! Max hit points */
	short int dmg;   /*! Damage per attack */
} monster_type;

/*! \brief Temporary structure for monsters 
 * \todo Should be moved to its own file
 * \todo Monsters and combat to be implemented
 */
typedef struct _monster {
	short int hits; /*! when this gets to zero, the monster dies */
	monster_type *species; /*! A pointer to the monster type structure */
} monster;

/*! \brief Create a monster of the given type */
monster *create_monster(monsters type);

/*! \brief Deallocate a monster of the given type */
void destroy_monster(monster *m);

/*! \brief Get the monster type from the symbol (char) */
monsters get_monster_type_from_symbol(char sym);
 #endif /* MONSTERS_H */
