#ifndef ACTIONS_H
#define ACTIONS_H
/*! \file actions.h
 *  \brief Management of PC actions based on #command items 
 */
#include "commands.h"
#include "character.h"
#include "level.h"

/*! \brief Action dispatcher 
 *
 * This function takes as input a command number, and calls
 * the corresponding action_ function.
 * This type of programming pattern is called a dispatcher.
 * \todo This function could be better implemented through 
 * function pointers. This is left as an (advanced!) exercise.
 */
void action(Level *level, character *pc, command cmd);

#endif /* ACTIONS_H */
