#include "items.h"
#include "utils.h"

/*! A structure containing pre-defined item classes
 *  \todo Exercise: replace this structure with a dynamic one
 *  where information from a configuration file is loaded
 */
item_class item_classes[NITEMTYPES+1] = {
                        /* Num, Mgc, Fd,Dmg,Wld,Qvr */
  { NOITEM,'\0', "none",     0,  0,  0,  0,  0,  0 },
	{ COINS,  '$', "coins", 1000,  0,  0,  0,  0,  0 },
	{ TREE,   'T', "tree",     1,  0,  0,  0,  0,  0 }, 
	{ FUNGUS, 'F', "fungus",   1,  0,  0,  0,  0,  0 }, 
	{ ARROW,  '(', "arrow",   30,  2,  0,  0,  0,  1 }, 
	{ SCROLL, '%', "scroll",  10,  3,  0,  0,  0,  0 }, 
	{ SWORD,  ')', "sword",    1,  3,  0,  4,  1,  0 },
	{ BOW,    ')', "bow",      1,  2,  0,  4,  1,  0 },
	{ TOME,   '%', "tome",     1,  2,  0,  4,  1,  0 },
	{ NITEMTYPES, '\0', "stop", 0, 0, 0, 0 }, 
};


item_types get_item_type_from_symbol(char sym){
	int i;
	for(i=1; item_classes[i].symbol!='\0'; i++){
		if (item_classes[i].symbol==sym) return i;
	}
	return NOITEM;
}

char get_item_symbol(item *it){
	return item_classes[it->type].symbol;
}

item *create_item(item_types type, int quantity, 
          int magic, char *text, int special){
	item *the_item=dmalloc(sizeof(item));
	the_item->type=type;
	the_item->quantity=quantity;
	the_item->magic=magic;
	the_item->text=text;
	the_item->special=special;
	return the_item;
}

int damage(item *it){
	item_class itcl=item_classes[it->type];
	return itcl.damage+it->magic;	
}
