#include "monsters.h"
#include "utils.h"

/*! A structure containing pre-defined monster types
 *  \todo Exercise: replace this structure with a dynamic one
 *  where information from a configuration file is loaded
 */
monster_type monster_types[NMONSTERTYPES+1] = {
                        /* mght,spd,mnd,hit,dmg */
  { NOMONST,'\0',"none",     0,  0,  0,  0,  0 },
	{ RAT,    'r', "rat",      3,  4,  2,  2,  1 },
	{ KOBOLD, 'k', "kobold",   6,  7,  6, 10,  2 }, 
	{ GOBLIN, 'g', "goblin",   8,  8,  6, 14,  3 }, 
	{ WOLF,   'w', "wolf",     9,  10, 4, 15,  3 }, 
	{ NMONSTERTYPES, '\0', "stop", 0, 0, 0, 0 }, 
};

monster *create_monster(monsters type){
	monster *res = dmalloc(sizeof(monster));
	res->species = &(monster_types[type]);
	res->hits = res->species->hits;
}

void destroy_monster(monster *m){
	dfree(m);
}

monsters get_monster_type_from_symbol(char sym){
	monsters i;
	for(i=NOMONST; i<NMONSTERTYPES; i++)
		if (monster_types[i].symbol==sym) return i;
	return NOMONST;
}
