#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/stat.h>
#include <errno.h>

#define MSGROT 2
#define MSGNROT 3

#define ROT13(msg) if (msg.mtext>='a' && msg.mtext<='z') { msg.mtype=MSGROT; msg.mtext='a'+(msg.mtext-'a'+13)%26; } else { msg.mtype=MSGNROT; }

#define IROT13(X) ( X>='a' && X<='z' ? 'a'+(X-'a'+13)%26 : X )

typedef struct my_msgbuf {
	long mtype;
	char mtext;
} msgtype;

int main(){
	int msgid;
	int pid;
	msgid = msgget(IPC_PRIVATE, IPC_CREAT | S_IRUSR | S_IWUSR);
	if (msgid<0) { perror("msgget"); exit(errno); }
	pid=fork();
	if (pid) {
		int n,s,er;
		msgtype buf1;

		s=sizeof(buf1)-sizeof(long);
		fprintf(stderr, "msgsndsize: %d\n",s);		
		while (1) {
			n=read(0, &(buf1.mtext), 1);
			buf1.mtext=IROT13(buf1.mtext);
			buf1.mtype=2;
			fprintf(stderr, "sending: %d, %c\n", buf1.mtype, buf1.mtext);
			er=msgsnd(msgid, &buf1, s, 0);
			if (er<0) {
				perror("msgsnd");
				break;				
			}
			if (n<0) {
				perror("read");
				break;
			} else if (n==0) {
				fprintf(stderr, "EOF\n");
				break;
			}
		}
		sleep(10);
		msgctl(msgid,IPC_RMID,0);
		exit(0);
	}
	else {
		msgtype buf2;
		int n,s;

		buf2.mtext=';';
		s = sizeof(buf2)-sizeof(long);
		fprintf(stderr, "msgrcvsize: %d\n",s);
		while (1) {
			n = msgrcv(msgid, &buf2, s, 2, 0);
			if (n==0){ fprintf(stderr, "Not reading...\n"); break; }
			else if (n<0) { perror("msgrcv"); if (errno==EINVAL) break; else sleep(1); }
			else fprintf(stderr, "received: %c\n", IROT13(buf2.mtext));
		}
	  /*msgctl(msgid,IPC_RMID,0);*/
		fprintf(stderr, "Reader closing\n");
		exit(0);
	}
	fprintf(stderr, "Something wrong here...\n");
}
