#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#define ROT13(X) ( X>='a' && X<='z' ? 'a'+(X-'a'+13)%26 : X )

int main(){
	int p;
	int pid;
	int buf;
	int n;
	pid=fork();
	if (pid) {
		p=open("./thefifo", O_WRONLY);
		if (p<0) { perror("open"); exit(errno); }
		else fprintf(stderr, "Fifo write open on %d\n", p);
		while (1) {
			n=read(0, &buf, 1);
			write(p, &buf, 1);
			if (n<1) { buf=EOF; write(p, &buf, 1); break; }		
		}
		close(p);
		exit(0);
	}
	else {
		int c;
		p=open("./thefifo", O_RDONLY);
		if (p<0) { perror("open"); exit(errno); }
		else fprintf(stderr, "Fifo read open on %d\n", p);
		while (1) {
			n=read(p, &buf, 1);
			if (buf==EOF) break;
			else if (n>0) { c=buf; write(1, &c, 1); }
		}
		close(p);
		exit(0);
	}
	fprintf(stderr, "Something wrong here...\n");
}
