#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#define ROT13(X) ( X>='a' && X<='z' ? 'a'+(X-'a'+13)%26 : X )

int main(){
	int p[2];
	int pid;
	int buf=0;
	int n;
	pipe(p);
	fcntl(p[1],F_SETFL,O_NONBLOCK);
	fcntl(p[0],F_SETFL,O_NONBLOCK);
	pid=fork();
	if (pid) {
		close(p[0]);
		sleep(1); /* We stop for 1 second to show what happens with the non-blocking calls */
		while (1) {
			n=read(0, &buf, 1);
			write(p[1], &buf, 1);
			if (n<1) { buf=EOF; write(p[1], &buf, 1); break; }		
		}
		exit(0);
	}
	else {
		close(p[1]);
		while (1) {
			n=read(p[0], &buf, 1);
			if (n<0) perror(NULL); /* Print an error code whenever the pipe is empty */
			else if (buf==EOF) break;
			else printf("%c", ROT13(buf));
		}
		exit(0);
	}
	fprintf(stderr, "Something wrong here...\n");
}
