#!/usr/bin/python

class EmptyQueueError(LookupError):
	def __str__(self):
		return 'Reading from empty queue!'

class Queue(object):
	def __init__(self):
		self.__list = []
	
	def dequeue(self):
		if len(self.__list) == 0 : raise EmptyQueueError
		res = self.__list[0]
		del self.__list[0]
		return res
	
	def enqueue(self,item):
		self.__list.append(item)
		
	def first(self):
		if len(self.__list) == 0 : return None
		return self.__list[0]

	def last(self):
		if len(self.__list) == 0 : return None
		return self.__list[-1]
	
	def __len__(self):
		return len(self.__list)
	
	def __str__(self):
		return str(self.__list)
		
if __name__ == '__main__' :
	q = Queue()
	print q.first()
	q.enqueue(1)
	q.enqueue(2)
	q.enqueue(5)
	print q.first()
	q.enqueue('pluto')
	q.enqueue(4.0)
	while 1 :
		print q.dequeue()
	
