#include <stdio.h>
#include <stdlib.h>

/* Riceve in ingresso due stringhe di caratteri 
   e li inserisce in due liste ordinate

	 Fonde le due liste ordinate in modo distruttivo
 */

/* Lista di caratteri */
typedef struct _list {
	char data;
	struct _list *next;
} list;

/* Crea e inizializza un nuovo elemento */
list *new_elem(char c){
	list *res = malloc(sizeof(list));
	res->data=c;
	res->next=0;
	return res;
}

/* Riceve puntatore alla testa della lista
   e il carattere c da inserire
	 Inserisce c in un nuovo elemento 
	 nell'ordine alfabetico
	 Restituisce il nuovo valore del puntatore
	 alla testa della lista (cambia se c e' 
	 il primo elemento) */
list *insert_in_order(list *h, char c){
	/* Crea il nuovo elemento c */
	list *elem=new_elem(c);
	list *current;
	if (h==0) {
		/* Lista vuota inizialmente */
		return elem; /* Il nuovo elemento e' in testa alla lista */
	}
	
	if (h->data>c){
		/* Inserimento in testa, c e' minore di tutti gli altri elementi*/
		elem->next=h;
		return elem; /* Il nuovo elemento e' in testa alla lista */
	}

	/* Ciclo che scorre la lista */
	for(current=h; current->next!=0; current=current->next){
		if (current->next->data>c){
			/* Inserimento fra current e current->next */
			elem->next=current->next;
			current->next=elem;
			return h; /* non cambia la testa della lista */
		}
	}
	/* Current punta alla coda della lista, inseriamo in coda */
	current->next=elem;
	return h; /* non cambia la testa della lista */
}

/* Inserisce in ordine l'elemento elem in una lista
   h gia' ordinata; restituisce la nuova testa */
list *insert_in_order_recursive(list *h, list *elem){
	list *current;
	/* Caso base: lista vuota */
	if (h==0) {
		/* Lista vuota inizialmente */
		return elem; /* Il nuovo elemento e' in testa alla lista */
	}
	
	/* Caso generale */
	if (h->data > elem->data){
		/* elem va inserito in testa */
		elem->next=h;
		return elem; /* Il nuovo elemento e' in testa alla lista */
	} else {
		/* elem non va inserito in testa */
		/* Passo ricorsivo + costruzione del risultato */
		h->next=insert_in_order_recursive(h->next, elem);
		return h;
	}
	/* hic sunt leones */
}

/* Inserisce in ordine l'elemento elem in una lista
   h gia' ordinata; restituisce la nuova testa */
list *insert_in_order_recursive_from_char(list *h, char c){
	/* Crea il nuovo elemento c */
	list *elem=new_elem(c);
	return insert_in_order_recursive(h, elem);
}

void print_list(list *h){
	list *current;
	for(current=h; current!=0; current=current->next){
		printf("%c", current->data);
	}	
	printf("\n");
}

void print_list_recursive(list *h){
	/* Caso base: lista vuota */
	if (h==0) printf("\n");
	else {
	/* Caso generale */
		printf("%c", h->data);
		/* Passo ricorsivo */
		print_list_recursive(h->next);
	}
}


/* Crea una lista a partire da una stringa,
   ordinando gli elementi */
list *new_sorted_list_from_string(char *input){
	char c;
	int i;
	list *head=0;
	for(i=0; input[i]!='\0'; i++){
		c=input[i];
		head=insert_in_order(head,c);
	}
	return head;
}


/* Crea una nuova lista contenente gli elementi di 
  h1 e h2, ordinati; h1 e h2 devono essere ordinate */
list *merge_ordered_list(list *h1, list *h2){
	list *hm=0; /* testa della nuova lista */
	list *tm=0; /* coda della nuova lista */
	/* Inserisce il primo elemento nella lista hm */ 
	if (h1->data < h2->data) {
		hm=h1;
		h1=h1->next;
		hm->next=0;		
		tm=hm;
	} else {
		hm=h2;
		h2=h2->next;
		hm->next=0;		
		tm=hm;
	}

	while(h1!=0 && h2!=0) {
		if (h1->data < h2->data) {
			tm->next=h1;
			h1=h1->next;
			tm=tm->next;
			tm->next=0;
		} else {
			tm->next=h2;
			h2=h2->next;
			tm=tm->next;
			tm->next=0;			
		}
	}
	
	/* Solo una fra h1 e h2 puo' avere ancora elementi
	   attacca ad hm->....->tm->h1 oppure h2 */
	if (h1!=0) tm->next=h1;
	if (h2!=0) tm->next=h2;
	return hm;
}


/* Crea una nuova lista contenente gli elementi di 
  h1 e h2, ordinati; h1 e h2 devono essere ordinate */
list *merge_ordered_list_recursive(list *h1, list *h2){
	/* Caso base: una sola lista non nulla */
	if (h1==0) return h2;
	if (h2==0) return h1;
	/* Caso generale: entrambe le liste h1 e h2 hanno elementi */
	if (h1->data > h2->data){
		/* Passo ricorsivo + costruzione del risultato 
			Il passo ricorsivo costruisce la lista ordinata per tutti
			i valori dell'input tranne il primo (il piu' piccolo) */
		h2->next=merge_ordered_list_recursive(h1,h2->next);
		return h2;
	} else {
		/* Come sopra, quando il primo elemento e' in h1 */ 
		h1->next=merge_ordered_list_recursive(h1->next,h2);	
		return h1;
	}
}


/* Crea una nuova lista contenente gli elementi di 
  h1 e h2, ordinati; h1 e h2 non devono essere ordinate 
	L'operazione non distrugge h1 e h2 */
list *merge_unordered_list(list *h1, list *h2){
	list *hm=0;
	list *current;
	for(current=h1; current!=0; current=current->next)
		hm=insert_in_order(hm,current->data);
	for(current=h2; current!=0; current=current->next)
		hm=insert_in_order(hm,current->data);
	return hm;	
}

/* Crea una nuova lista contenente gli elementi di 
  h1 e h2, ordinati; h1 e h2 non devono essere ordinate 
	L'operazione distrugge h1 e h2 */
list *merge_unordered_list_destructive(list *h1, list *h2){
	list *hm=0;
	list *current;
	for(current=h1; current!=0; current=current->next)
		hm=insert_in_order_recursive(hm,current);
	for(current=h2; current!=0; current=current->next)
		hm=insert_in_order_recursive(hm,current);
	return hm;	
}


int main(int argc, char **argv){
	if (argc<3) return -1;
	list *head1=new_sorted_list_from_string(argv[1]);
	list *head2=new_sorted_list_from_string(argv[2]);
	list *hmerge=0;	

	print_list(head1);
	print_list(head2);
	
	hmerge=merge_ordered_list_recursive(head1, head2);
	
	print_list_recursive(hmerge);
}
