#include <stdio.h>
#include <stdlib.h>

/* Riceve in ingresso una stringa di caratteri 
   e li inserisce in una lista ordinata */

/* Lista di caratteri */
typedef struct _list {
	char data;
	struct _list *next;
} list;

/* Crea e inizializza un nuovo elemento */
list *new_elem(char c){
	list *res = malloc(sizeof(list));
	res->data=c;
	res->next=0;
	return res;
}

/* Riceve puntatore alla testa della lista
   e il carattere c da inserire
	 Inserisce c in un nuovo elemento 
	 nell'ordine alfabetico
	 Restituisce il nuovo valore del puntatore
	 alla testa della lista (cambia se c e' 
	 il primo elemento) */
list *insert_in_order(list *h, char c){
	/* Crea il nuovo elemento c */
	list *elem=new_elem(c);
	list *current;
	if (h==0) {
		/* Lista vuota inizialmente */
		return elem; /* Il nuovo elemento e' in testa alla lista */
	}
	
	if (h->data>c){
		/* Inserimento in testa, c e' minore di tutti gli altri elementi*/
		elem->next=h;
		return elem; /* Il nuovo elemento e' in testa alla lista */
	}

	/* Ciclo che scorre la lista */
	for(current=h; current->next!=0; current=current->next){
		if (current->next->data>c){
			/* Inserimento fra current e current->next */
			elem->next=current->next;
			current->next=elem;
			return h; /* non cambia la testa della lista */
		}
	}
	/* Current punta alla coda della lista, inseriamo in coda */
	current->next=elem;
	return h; /* non cambia la testa della lista */
}

void print_list(list *h){
	list *current;
	for(current=h; current!=0; current=current->next){
		printf("%c", current->data);
	}	
	printf("\n");
}


int main(int argc, char **argv){
	if (argc<2) return -1;
	char *input = argv[1];
	list *head=0;
	char c;
	int i;
	
	for(i=0; input[i]!='\0'; i++){
		c=input[i];
		head=insert_in_order(head,c);
	}
	
	print_list(head);
}
