#include <stdio.h>
#include <string.h>

/* abfgkmop 
	g 3 ^ 4
	b1^   6 

*/
int search_binary_recursive(char *string, char key){
	int len=strlen(string);
	int pos=len/2;
	char c=string[pos];
	printf("%c\n",c);
	if (c==key) return pos;
	else if (len<=1) return -1;
	else if (c>key) { 
		/* cerca nella parte iniziale */
		string[pos]='\0';
	 	return search_binary_recursive(string, key);
	}
	else {
		/* cerca nella parte finale */ 
		return search_binary_recursive(string+pos+1, key);
	}
}


/*
	0      len-1 
	abfgkmop\0
key = f
	initial=0
	final=8
	central=4	 -> c = k

	initial=0
	final=4
	len=4
	central=2	-> c = f
	
	fine: c==key
	
*/
int search_binary_iterative(char *string, char key){
	int initial=0;
	int final=strlen(string);
	int len;
	int central; 
	char c;
	while((final-initial)>1){
		len=(final-initial);
		central=initial+(len/2);
		c=string[central];
		printf("%c\n",c);
		if (c==key) return central;
		else if (c>key) {  /* cerca nella parte iniziale:
													da 0 a central */
			 final=central;
		}
		else {/* cerca nella parte finale 
					da central+1 a len */ 
			 initial=central+1;
		}
	}
	if (string[initial]==key) return initial;
	else return -1;
}

/* Ricerca in una stringa generica */
int search_iterative(char *string, char key){
	int i;
	for(i=0; i<strlen(string); i++){
		if (string[i]==key) return i;
	}
	return -1;
}

/* Ricerca in una stringa generica 
  abfgkmop\0
key = f
	Ncall		string[0]	return
	1				a					+1
	2				b					+1
	3				f					0

	return se key non e' in string:
		strlen(string) +1

 */
int __search_recursive(char *string, char key){
	if (strlen(string)==0) return +1;
	if (string[0]==key) return 0;
	else return search_recursive(string+1, key)+1;
}

/* wrapper */
int search_recursive(char *string, char key){
	int pos=__search_recursive(string, key);
	if (pos>=strlen(string)) return -1;
}

int main(int argc, char **argv){
	int pos;
	if(argc<3) {
		printf("Non sono presenti i due argomenti\n");
		return -1;
	}
	pos=search_binary_iterative(argv[1], argv[2][0]);
	if (pos==-1) printf("Carattere non trovato\n");
	else	printf("Posizione: %d\n",pos+1);
	return 0;
}
