/*
  Stringhe senza \0
 */

#include <string.h> 

typedef struct _string {
	int len;
	char *value;
} string;

string *string_alloc(){
	string *new_string=malloc(sizeof(string));
	new_string->len=0;
	new_string->value=0;
	return new_string;
}

void string_free(string *str){
	free(str->value);
	free(str);
}

string *string_new(char *str){
	string *new_string=malloc(sizeof(string));
	/* (*new_string).len */
	new_string->len=strlen(str);
	new_string->value=malloc(sizeof(char)*new_string->len);
	strncpy(new_string->value,str,new_string->len);
	return new_string;
}

int string_len(string *str){
	return str->len;
}

void string_copy(string *dest, string *src){
	if (dest->value) free(dest->value);
	dest->len=src->len;
	dest->value=malloc(sizeof(char)*dest->len);
	strncpy(dest->value, src->value, dest->len);
}

string *string_dup(string *src){
	string *dest=string_alloc();
	string_copy(dest, src);
	return dest;
}

int string_cmp(string *s1, string *s2){
	int min_len;
	int i;
	if (s1->len>s2->len) min_len=s2->len;
	else min_len=s1->len;
	for(i=0; i<min_len; i++){
		if (s1->value[i]>s2->value[i]) return 1;
		else if (s1->value[i]<s2->value[i]) return -1;
	}
	if (s2->len==s1->len) return 0;
	if (s2->len>s1->len) return -1;
	else return 1;
}

string *string_cat(string *s1, string *s2){
	string *res=string_alloc();
	res->len=s1->len+s2->len;
	res->value=malloc(sizeof(char)*res->len);
	strncpy(res->value,s1->value,s1->len);
	strncpy(res->value+s1->len,s2->value,s2->len);
	return res;
}
