#!/usr/bin/python
__doc__ = '''A minimal structure for a real-time game featuring a saucer.
Version 1 only has a single saucer, player-controlled.'''
import pygame
import pygame.event
from pygame.locals import *

X, Y = 500, 500 # Controls the screen size
T = 40 # Controls the timing, one movement every T milliseconds
S = 15 # Controls the step size in pixels

class Saucer(object):
	'''Description of a saucer, characterized by position (x,y), radius r, and color (r,g,b)'''
	def __init__(self, size, color, pos):
		self.radius=size
		self.color=color
		self.pos=pos

class GameBoard(object):
	'''Description of the game board and all the related functionalities'''
	def __init__(self, X,Y):
		self.X=X
		self.Y=Y
		pygame.init()
		self.srect=Rect(0,0,self.X, self.Y)
		self.screen=pygame.display.set_mode(self.srect.size,0)
		self.bg = pygame.Surface(self.srect.size)
		self.clock=pygame.time.Clock()
		pygame.display.set_caption('Saucers')
		pygame.key.set_repeat(T,T)
		self.player=Saucer(30, (0,120,255), (self.X/2, self.Y/2))

	def blitAll(self):
		# Draw black screen
		self.screen.fill((0,0,0))
		# Draw player
		pygame.draw.circle(self.screen, self.player.color, self.player.pos, self.player.radius)
		# Update the display
		pygame.display.update()

	def run(self):
		'''Game loop'''
		while True : # infinite loop
			for e in pygame.event.get(): #check for events (keys pressed)
					print e
					cmd=pygame.key.get_pressed() # get all pressed keys!
					x, y = self.player.pos
					if cmd[K_q] : return # if 'q' pressed, leave game
					# check all possible movement keys
					if cmd[K_a] or cmd[K_LEFT] : self.player.pos = x-S, y
					if cmd[K_d] or cmd[K_RIGHT] : self.player.pos = x+S, y
					if cmd[K_s] or cmd[K_DOWN] : self.player.pos = x, y+S
					if cmd[K_w] or cmd[K_UP] : self.player.pos = x, y-S
			self.blitAll() # update the screen
			pygame.time.delay(T) # wait T milliseconds

if __name__ == "__main__" :
	game=GameBoard(X,Y)
	game.run()
